﻿/*

1. Needs to create an evaluation function per input type
2. Needs to trigger multiple evaluating function when a value changes

*/

function htmlEncode(value) {
    return $('<div/>').text(value).html();
}

function htmlDecode(value) {
    return $('<div/>').html(value).text();
}

///
/// Editable labels for the variables
///
$(function () {
    $('.disableIf').each(function () {
        try {
            var currentCell = $(this);
            var variables = JSON.parse(htmlDecode($(this).attr('disableifvariables')));
            var values = JSON.parse(htmlDecode($(this).attr('disableifvalues')));

            if (variables.length === values.length) {
                var valuesByVariable = _.groupBy(values, function (value, index) { return variables[index]; });
                var variablesUniq = _.uniq(variables);
                var disableIfControls = [];
                // Generate a function
                var functionCode = 'false'; // Default value so we can add "OR" conditions easily

                $.each(variablesUniq, function (i, variable) {
                    var variableValues = valuesByVariable[variable];
                    var inputselector = ':input[name=' + variable + ']';
                    var valuesStr = "[" +variableValues.map(function (v) { return "'" + v + "'"; }).join(",") + "]";

                    var input = $(inputselector);
                    var selectionCondition = (input.is(":radio") || input.is(":checkbox")) ? ":checked" : "";
                    var conditionCode = "$.inArray($('" + inputselector + selectionCondition + "').val(), " + valuesStr + ") !== -1";

                    if ($.inArray(inputselector, disableIfControls) === -1) {
                        functionCode += " || " + conditionCode;
                        disableIfControls.push(inputselector);
                    }
                });

                // On the change event of the parent controls, call the generated function
                $.each(disableIfControls, function (i, disableIfControl) {
                    var onChange = function () {
                        if (eval(functionCode) == true) {
                            currentCell.addClass("disabled");
                            // Clear values on input that are to be disabled                            
                            currentCell.find(':input').prop("disabled", true);
                            currentCell.find('.sliderBar').slider('option', 'disabled', true);
                            currentCell.find(':voxco-starRating').starRating('disable');
                            currentCell.find(':input').each(function () {
                                if ($(this).attr('type') === 'checkbox' || $(this).attr('type') === 'radio') {
                                    $(this).prop('checked', false);
                                    $(this).closest(".choice").addClass("disabled");
                                    if (defaultRadioImage) {
                                        $(this).siblings(".radioImage").attr("src", defaultRadioImage);
                                    }
                                    if (defaultCheckBoxImage) {
                                        $(this).siblings(".checkboxImage").attr("src", defaultCheckBoxImage);
                                    }
                                } else {
                                    $(this).val('');
                                }
                            });
                        } else {
                            currentCell.removeClass("disabled");

                            currentCell.find(':input').prop('disabled', false);
                            currentCell.find('.sliderBar').slider('option', 'disabled', false);
                            currentCell.find(':voxco-starRating').starRating('enable');

                            currentCell.find(':input').each(function () {
                                if ($(this).attr('type') === 'checkbox' || $(this).attr('type') === 'radio') {
                                    $(this).closest(".choice").removeClass("disabled");
                                }
                            });
                        }
                    };

                    onChange();

                    $(disableIfControl).on("change", onChange);
                });
            }
        } catch (_error) { }
    });
});
